@extends('schoolLayout.app')

@section('content')
<div class="px-6 py-6 bg-[#f9fafc] min-h-screen">
    <h2 class="text-2xl font-bold mb-4">Documents for {{ $student->student_name }}</h2>

    <div class="mb-6 space-y-2">
        <p><strong>Father Name:</strong> {{ $student->father_name }}</p>
         <p><strong>Registration No:</strong> {{ $student->reg_no }}</p>
    </div>

    <div class="space-y-4">
        @php
            $documents = [
                'photo' => 'Student Photo',
                'birth_certificate' => 'Birth Certificate',
                'school_leaving_certificate' => 'School Leaving Certificate',
            ];
        @endphp

       <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
            @foreach ($documents as $field => $label)
                @if (!empty($student->documents->$field))
                    <div class="bg-white rounded shadow p-3 max-w-md w-full mx-auto flex items-center justify-between">
                        <div class="space-y-0.5">
                            <h4 class="text-sm font-semibold text-gray-800">{{ $label }}</h4>
                            <p class="text-xs text-gray-500">
                                Uploaded on {{ $student->documents->created_at->format('d M Y') }}
                            </p>
                        </div>
                        <a download href="{{ url('download/student-photo/' . basename($student->documents->$field)) }}" class="text-blue-600 hover:text-blue-800">
                            <i class="fa-solid fa-download text-base" aria-hidden="true"></i>
                        </a>
                    </div>
                @endif
            @endforeach

        </div>

    </div>

    <div class="mt-8 bg-white p-6 rounded-lg shadow-md">
    <h2 class="text-xl font-semibold mb-2 text-gray-800">Examination Documents</h2>
    <p class="text-gray-600 mb-4">
        Here you can view and download the documents related to the student's examinations.
    </p>

    <h3 class="text-lg font-semibold text-gray-700 mb-3">All Enrolled Exams</h3>

    <div class="overflow-x-auto">
        <table class="min-w-full text-sm text-left border border-gray-200">
            <thead class="bg-gray-100 text-gray-700 uppercase">
                <tr>
                    <th class="px-4 py-2 border">Exam Title</th>
                    <th class="px-4 py-2 border">Type</th>
                    <th class="px-4 py-2 border">Session</th>
                    <th class="px-4 py-2 border">Notes</th>
                    <th class="px-4 py-2 border text-center">Action</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-200">
                @foreach ($studentExams as $exam)
                    <tr class="hover:bg-gray-50">
                        <td class="px-4 py-2 border">{{ $exam->exam_title }}</td>
                        <td class="px-4 py-2 border">{{ $exam->type }}</td>
                        <td class="px-4 py-2 border">{{ $exam->academic_session }}</td>
                        <td class="px-4 py-2 border">{{ $exam->notes }}</td>
                        <td class="px-4 py-2 border text-center">
                            <a href="{{ route('docs.students.exam.dmc', [$studentId, $exam->exam_id]) }}"
                               class="text-blue-600 hover:underline font-semibold">
                               Generate DMC
                            </a>
                        </td>
                    </tr>
                @endforeach

                @if($studentExams->isEmpty())
                    <tr>
                        <td colspan="5" class="px-4 py-2 text-center text-gray-500">
                            No exams found for this student.
                        </td>
                    </tr>
                @endif
            </tbody>
        </table>
    </div>
</div>


</div>
@endsection
