@extends('schoolLayout.app')
@section('content')
<div class="px-6 py-6 bg-[#f9fafc] min-h-screen">

    <!-- Search Bar -->
    <form method="GET" class="mb-6">
        <div class="flex items-center space-x-2">
            <input type="text" name="search" value="{{ $search ?? '' }}" placeholder="Search staff by name..."
                class="px-4 py-2 border rounded-md w-64" />
            <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700">
                Search
            </button>
        </div>
    </form>

    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        @forelse ($staff as $person)
            <div class="bg-white p-4 rounded-lg shadow-md">
                <!-- Staff Info -->
                <div class="mb-3 space-y-1">
                    <h3 class="text-lg font-bold text-gray-800">{{ $person->full_name }}</h3>
                    <p class="text-sm text-gray-600">Email: {{ $person->email }}</p>
                    <p class="text-sm text-gray-600">CNIC: {{ $person->cnic }}</p>
                    <p class="text-sm text-gray-600">Reg. No: {{ $person->registration_no }}</p>
                </div>

                <!-- Document Info -->
                @php
                    $documents = [
                        'cv_resume' => 'CV/Resume',
                        'degree_certificate' => 'Degree Certificate',
                        'transcript' => 'Transcript',
                    ];
                @endphp

                @foreach ($documents as $field => $label)
                    @if (!empty($person->$field))
                        <div class="border-t pt-2 mt-3">
                            <div class="flex justify-between items-center pb-2">
                                <div class="flex items-center space-x-4">
                                    <i class="fa-solid fa-file-pdf text-red-500"></i>
                                    <div>
                                        <h4 class="text-md font-semibold text-gray-800">{{ $label }}</h4>
                                        <p class="text-sm text-gray-600">
                                            Uploaded on {{ $person->created_at->format('d M Y') }}
                                        </p>
                                    </div>
                                </div>
                                <span class="bg-[#FEE2E2] text-[#991B1B] px-3 py-0.5 rounded-2xl text-sm inline-flex items-center gap-x-2">
                                    <i class="fa-solid fa-circle-check"></i> Verified
                                </span>
                            </div>

                            <div class="flex space-x-3 text-blue-600 justify-end items-center mt-3">
                                <!-- <a href="{{ asset('storage/' . $person->$field) }}"
                                    download="{{ $field }}_{{ $person->id }}"
                                    class="text-blue-500 hover:text-blue-700">
                                    <i class="fa-solid fa-download cursor-pointer"></i>
                                    </a> -->


                                     <a  download="{{ $field }}_{{ $person->id }}" href="{{ url('download/staff-photo/' . basename($person->$field)) }}" class="text-blue-600 hover:text-blue-800">
                            <i class="fa-solid fa-download text-base" aria-hidden="true"></i>
                        </a>


                            </div>
                        </div>
                    @endif
                @endforeach

                                <!-- End of Document Info -->
            </div>
        @empty
            <p class="text-gray-600 col-span-3">No matching staff found.</p>
        @endforelse
    </div>

</div>
@endsection
