<body style="background-color:#f7fafc; display:flex; align-items:center; justify-content:center; min-height:100vh; margin:0;">
  <!-- Modal Background -->
  <div style="position:fixed; inset:0; background-color:rgba(0,0,0,0.5); display:flex; align-items:center; justify-content:center; z-index:50;">
    <!-- Modal Content -->
    <div style="background-color:white; width:100%; max-width:768px; max-height:100vh; overflow-y:auto; border-radius:0.5rem; box-shadow:0 0 10px rgba(0,0,0,0.1);">
      
 

      <!-- Header -->
      <div style="display:flex; justify-content:space-between; align-items:center; padding:1.5rem 1.5rem 1rem;">
      <div style="width:4rem; height:4rem; background-color:#e2e8f0; display:flex; align-items:center; justify-content:center; font-size:0.875rem;">
      <img src="{{ $logoBase64 }} " alt="logo" style="min-width:32px; min-height:32px; max-width:100%; max-height:100%;" />
</div>


        <div style="text-align:center; flex:1; margin-left:-4rem;">
          <h1 style="font-size:1.125rem; font-weight:bold; text-transform:uppercase;">{{ $schoolName }}</h1>
          <p style="font-size:0.875rem;">{{ $schoolAddress }}</p>
          <p style="font-size:0.875rem;">{{ $schoolContact }} | {{ $schoolEmail }}</p>
        </div>
      </div>
      
      <div style="border-bottom:1px solid #4a5568;"></div>

      <!-- Title -->
      <div style="padding:1rem 1.5rem;">
        <h2 style="text-align:center; font-size:1rem; font-weight:bold; text-transform:uppercase;">Detailed Marks Certificate</h2>
        <p style="text-align:center; font-size:0.875rem; margin-bottom:1rem;">{{ $dmcData[0]->exam_name }} Examination {{$school_session}}</p>

        <!-- Student Info -->
        <div style="display:grid; grid-template-columns:repeat(3, 1fr); gap:0.5rem; font-size:0.875rem; margin-bottom:0.75rem;">
          <div style="white-space:nowrap;">
            <span style="font-weight:600; color:#4b5563;">Admission Number</span>
            <span style="border-bottom:1px solid black; font-weight:bold; display:inline-block; width:4rem; text-align:center; margin-left:0.25rem;">{{ $dmcData[0]->reg_no }}</span>
          </div>
          <div style="white-space:nowrap; text-align:center;">
            <span style="font-weight:600; color:#4b5563;">Class</span>
            
            <span style="border-bottom:1px solid black; font-weight:bold; display:inline-block; width:3rem; margin-left:0.25rem;">{{ $class_name ?? 'N/A' }}</span>
          </div>
          <div style="white-space:nowrap;">
            <span style="font-weight:600; color:#4b5563;">Section</span>
            <span style="border-bottom:1px solid black; font-weight:bold; display:inline-block; width:3rem; text-align:center; margin-left:0.25rem;">{{ $section_name ?? 'N/A' }}</span>
          </div>
        </div>

        <div style="display:grid; grid-template-columns:repeat(2, 1fr); gap:1rem; font-size:0.875rem; margin-bottom:1rem;">
          <div>
            <span style="font-weight:600; color:#4b5563;">Student Name</span>
            <span style="border-bottom:1px solid black; font-weight:bold; display:inline-block; width:8rem; margin-left:0.25rem;">{{ $dmcData[0]->student_name }}</span>
          </div>
          <div>
            <span style="font-weight:600; color:#4b5563;">Father Name</span>
            <span style="border-bottom:1px solid black; font-weight:bold; display:inline-block; width:8rem; margin-left:0.25rem;">{{ $dmcData[0]->father_name }}</span>
          </div>
        </div>

        <!-- Table -->
        <table style="width:100%; font-size:0.875rem; margin-bottom:1rem; border-collapse:collapse;">
          <thead style="font-weight:500; border:1px solid #cbd5e0;">
            <tr>
              <th style="border:1px solid #000; padding:0.25rem 0.5rem; text-align:left;" rowspan="2">SUBJECT</th>
              <th style="border:1px solid #000; padding:0.25rem 0.5rem; text-align:center;" rowspan="2">MARKS</th>
              <th style="border:1px solid #000; padding:0.25rem 0.5rem; text-align:center;" colspan="4">MARKS OBTAINED</th>
            </tr>
            <tr>
              <th style="border:1px solid #000; padding:0.25rem 0.5rem; text-align:center;">THEORY</th>
              <th style="border:1px solid #000; padding:0.25rem 0.5rem; text-align:center;">ORAL</th>
              <th style="border:1px solid #000; padding:0.25rem 0.5rem; text-align:center;">TOTAL</th>
              <th style="border:1px solid #000; padding:0.25rem 0.5rem; text-align:center;">REMARKS</th>
            </tr>
          </thead>
          <tbody>
            <!-- Repeat for subjects -->
          @foreach ($dmcData as $record)
    @php
        $subject = $subjectDetails[$record->subject_name] ?? null;
        $total = $subject->total_marks ?? 100;
        $passing = $subject->passing_marks ?? 33;
    @endphp
      <tr>
          <td style="border:1px solid #000; padding:0.25rem 0.5rem;">
              {{ $record->subject_name }}
          </td>
          <td style="border:1px solid #000; text-align:center;">
              {{ $total }}
          </td>
          <td style="border:1px solid #000; text-align:center;">
              {{ $record->marks }}
          </td>
          <td style="border:1px solid #000; text-align:center;">
              <!-- {{ $record->marks }} -->--
          </td>
          <td style="border:1px solid #000; text-align:center;">
               {{ $record->marks }}  
          </td>
          <td style="border:1px solid #000; text-align:center;">
              {{ $record->marks >= $passing ? 'PASS' : 'FAIL' }}
          </td>
      </tr>
  @endforeach


            <!-- ...repeat other rows similarly... -->

            <!-- Summary Rows -->
                @php
            $totalMarks = $dmcData->sum('marks');
            $grade = '';

            if ($totalMarks >= 400) {
                $grade = 'A';
            } elseif ($totalMarks >= 350) {
                $grade = 'B';
            } elseif ($totalMarks >= 300) {
                $grade = 'C';
            } elseif ($totalMarks >= 250) {
                $grade = 'D';
            } elseif ($totalMarks >= 200) {
                $grade = 'E';
            } else {
                $grade = 'F';
            }

            // Optional: get subject codes from subject names (abbreviated)
            $remarks = $dmcData->pluck('subject_name')->map(function ($subject) {
                return strtoupper(substr($subject, 0, 3)); // First 3 letters in uppercase
            })->join('-');
        @endphp


        @php
    use Illuminate\Support\Facades\DB;

    // Get subject names from DMC data
    $subjectNames = $dmcData->pluck('subject_name')->toArray();

    // Get total marks for these subjects from the 'subjects' table
    $totalOutOf = DB::table('subjects')
        ->whereIn('name', $subjectNames)
        ->sum('total_marks'); // assuming 'total_marks' column holds full marks for the subject

    $obtainedMarks = $dmcData->sum('marks');

    $grade = '';
    if ($obtainedMarks >= 0.8 * $totalOutOf) {
        $grade = 'A';
    } elseif ($obtainedMarks >= 0.7 * $totalOutOf) {
        $grade = 'B';
    } elseif ($obtainedMarks >= 0.6 * $totalOutOf) {
        $grade = 'C';
    } elseif ($obtainedMarks >= 0.5 * $totalOutOf) {
        $grade = 'D';
    } elseif ($obtainedMarks >= 0.4 * $totalOutOf) {
        $grade = 'E';
    } else {
        $grade = 'F';
    }

     
@endphp



        <tr style="font-weight:600;">
            <td style="border:1px solid #000; padding:0.25rem 0.5rem;">TOTAL MARKS:</td>
            <td style="border:1px solid #000; text-align:center;">{{$totalOutOf}}</td>
            <td style="text-align:center;"></td>
            <td style="text-align:center;"></td>
            <td style="border:1px solid #000; text-align:center;" colspan="2">{{ $obtainedMarks }}</td>
        </tr>
        <tr>
            <td style="padding:0.25rem 0.5rem; text-align:right;" colspan="4">Remarks</td>
            <td style="border:1px solid #000; text-align:left; padding:0.25rem 0.5rem;" colspan="2">{{ $remarks }}</td>
        </tr>

          </tbody>
        </table>

        <!-- Footer -->
        <div style="display:grid; grid-template-columns:repeat(3, 1fr); gap:0.5rem 1rem; font-size:0.875rem; margin:1rem 0;">
          <div style="white-space:nowrap;">
            <span style="font-weight:600; color:#4b5563;">Position</span>
            <span style="border-bottom:1px solid black; display:inline-block; width:3rem; margin-left:0.25rem;"></span>
          </div>
          <div style="white-space:nowrap;">
            <span style="font-weight:600; color:#4b5563;">Out of</span>
            <span style="border-bottom:1px solid black; display:inline-block; width:3rem; margin-left:0.25rem;">3</span>
          </div>
          <div style="white-space:nowrap;">
            <span style="font-weight:600; color:#4b5563;">Percentage</span>
            <span style="border-bottom:1px solid black; display:inline-block; width:3rem; margin-left:0.25rem;">48.6%</span>
          </div>
          <div style="white-space:nowrap;">
            <span style="font-weight:600; color:#4b5563;">Teacher Name</span>
            <span style="border-bottom:1px solid black; display:inline-block; width:4rem; margin-left:0.5rem;">Test</span>
          </div>
          <div style="white-space:nowrap;" colspan="2">
            <span style="font-weight:600; color:#4b5563;">Signature</span>
            <span style="border-bottom:1px solid black; display:inline-block; width:4rem; margin-left:0.5rem;"></span>
            <span style="font-weight:600; color:#4b5563; margin-left:1rem;">Parents Signature</span>
            <span style="border-bottom:1px solid black; display:inline-block; width:4rem; margin-left:0.5rem;"></span>
          </div>
        </div>

        <!-- Bottom -->
        <div style="font-size:0.875rem; margin-top:5rem; display:flex; justify-content:space-between; align-items:flex-end; padding-bottom:0.5rem;">
          <div>
            <p style="margin-bottom:0.25rem;">Issue Date: <span style="font-weight:600;">{{ \Carbon\Carbon::parse($issue_date)->format('d-M-Y') }}</span></p>
            <p style="font-size:0.75rem; margin-bottom:0.25rem;">Note/Errors/Omissions accepted</p>
            <p style="font-size:0.875rem;">Examination Department</p>
          </div>
          <div style="text-align:right;">
            <img src="{{ $exam_sign_Base64 }}" alt="signature" style="height:3rem; display:block; margin:auto;" />
            <p style="margin-top:0.5rem; font-size:0.875rem;">Controller of Examination</p>
          </div>
        </div>
      </div>
    </div>
  </div>
</body>
