<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Create New Class</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script
      src="https://kit.fontawesome.com/ee244dc737.js"
      crossorigin="anonymous"
    ></script>
  </head>
  <body class="bg-gray-100 flex items-center justify-center min-h-screen">
    <!-- Button to Open Modal -->
    <button
      id="openModal"
      class="px-4 py-2 bg-blue-600 text-white rounded hover:bg-blue-700"
    >
      Create New Class
    </button>

    <!-- Modal Background (Initially Hidden) -->
    <div
      id="modal"
      class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center hidden"
    >
      <!-- Modal Content -->
      <div
        class="bg-white w-full max-w-lg rounded-lg shadow-lg relative max-h-[80vh] overflow-y-auto"
      >
        <!-- Modal Header -->
        <div
          class="flex items-center px-4 py-6 border-b border-gray-200 justify-between"
        >
          <h2 class="text-xl font-semibold">Create New Class</h2>
          <button id="closeModal" class="text-gray-600 hover:text-gray-900">
            <i class="fa-solid fa-xmark"></i>
          </button>
        </div>

        <!-- Modal Body -->
        <div class="bg-white px-6 py-3">
          <!-- Session -->
          <div class="mb-4">
            <label class="block text-gray-700 font-semibold mb-1">
              Session <span class="text-red-500">*</span>
            </label>
            <select
              class="w-full border border-gray-300 p-2 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
            >
              <option value="">Select Session</option>
              <option value="2024-2025">2024-2025</option>
              <option value="2023-2024">2023-2024</option>
            </select>
          </div>

          <!-- Class Name -->
          <div class="mb-4">
            <label class="block text-gray-700 font-semibold mb-1">
              Class Name <span class="text-red-500">*</span>
            </label>
            <input
              type="text"
              placeholder="Grade 5, 8th, 10th"
              class="w-full border border-gray-300 p-2 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
            />
          </div>

          <!-- Class Code -->
          <div class="mb-4">
            <label class="block text-gray-700 font-semibold mb-1">
              Class Code <span class="text-red-500">*</span>
            </label>
            <input
              type="text"
              placeholder="CL-202"
              class="w-full border border-gray-300 p-2 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
            />
          </div>

          <!-- Sections -->
          <div class="mb-4">
            <label class="block text-gray-700 font-semibold mb-2">
              Sections <span class="text-red-500">*</span>
            </label>
            <div class="grid grid-cols-4 gap-4">
              <label class="flex items-center">
                <input type="checkbox" class="mr-2" />
                Section A
              </label>
              <label class="flex items-center">
                <input type="checkbox" class="mr-2" />
                Section B
              </label>
              <label class="flex items-center">
                <input type="checkbox" class="mr-2" />
                Section C
              </label>
              <label class="flex items-center">
                <input type="checkbox" class="mr-2" />
                Section D
              </label>
            </div>
          </div>

          <!-- Primary Teacher -->
          <div class="mb-4">
            <label class="block text-gray-700 font-semibold mb-1">
              Primary Teacher
            </label>
            <select
              class="w-full border border-gray-300 p-2 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
            >
              <option value="">Select Teacher</option>
              <option value="1">John Doe</option>
              <option value="2">Jane Smith</option>
              <option value="3">Emily Johnson</option>
            </select>
          </div>
        </div>

        <!-- Modal Footer -->
        <div
          class="flex justify-end border-t border-gray-200 bg-[#f9fafc] px-6 py-3 space-x-3"
        >
          <button
            id="closeModalBtn"
            class="px-4 py-2 border border-gray-500 text-gray-800 rounded"
          >
            Cancel
          </button>
          <button
            class="px-4 py-2 bg-[#0197FF] text-white rounded hover:bg-blue-700"
          >
            Create Class
          </button>
        </div>
      </div>
    </div>

    <script>
      // Modal functionality
      const modal = document.getElementById("modal");
      const openModalBtn = document.getElementById("openModal");
      const closeModalBtns = [
        document.getElementById("closeModal"),
        document.getElementById("closeModalBtn"),
      ];

      openModalBtn.addEventListener("click", () => {
        modal.classList.remove("hidden");
      });

      closeModalBtns.forEach((btn) => {
        btn.addEventListener("click", () => {
          modal.classList.add("hidden");
        });
      });
    </script>
  </body>
</html>
