<?php

namespace Database\Seeders;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class StudentCardsTemplatesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Insert template data
        DB::table('student_cards_templates')->insert([
            [
                'template_name' => 'template_left',
                'background_color' => 'linear-gradient(135deg, #2563eb -1%, #1d4ed8 50%, #1e40af 100%)',
                'text_color' => 'ffffff',
                'logo' => null,
                'logo_width' => 48,
                'logo_height' => 48,
                'photo_width' => 80,
                'photo_height' => 80,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'template_name' => 'template_right',
                'background_color' => 'linear-gradient(0deg, rgba(0, 0, 0, 0.001), rgba(0, 0, 0, 0.001)), rgba(0, 0, 0, 0), linear-gradient(135deg, #9333EA 1%, #7E22CE 49%, #3730A3 99%);',
                'text_color' => 'ffffff',
                'logo' => null,
                'logo_width' => 48,
                'logo_height' => 48,
                'photo_width' => 80,
                'photo_height' => 80,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'template_name' => 'template_bottom',
                'background_color' => 'linear-gradient(137deg, #059669 0%, #047857 50%, #115e59 100%);',
                'text_color' => 'ffffff',
                'logo' => null,
                'logo_width' => 48,
                'logo_height' => 48,
                'photo_width' => 80,
                'photo_height' => 80,
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ]);
    }
}