<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Carbon\Carbon;
use App\Models\School_setting;

class SchoolSettingsSeeder extends Seeder
{
    public function run()
    {
        $now = Carbon::now();
        $currentYear = $now->year;

        if ($now->month > 4) {
            $academicYear = $currentYear . '-' . ($currentYear + 1);
        } else {
            $academicYear = ($currentYear - 1) . '-' . $currentYear;
        }

        $settings = [
            [
                'setting_key' => 'school_name',
                'setting_value' => 'Your School Name',
            ],
            [
                'setting_key' => 'school_email',
                'setting_value' => 'Your School Email',
            ],
            [
                'setting_key' => 'school_address',
                'setting_value' => 'Your School Address',
            ],
            [
                'setting_key' => 'phone_number',
                'setting_value' => 'Your School Phone Number',
            ],
            [
                'setting_key' => 'school_timings',
                'setting_value' => '8:00 AM to 1:30 PM',
            ],
            [
                'setting_key' => 'session_start',
                'setting_value' => 'April 07, 2025',
            ],
            [
                'setting_key' => 'academic_year',
                'setting_value' => $academicYear,
            ],
            // Add more default settings as needed
        ];

        foreach ($settings as $setting) {
            School_setting::create([
                'setting_key' => $setting['setting_key'],
                'setting_value' => $setting['setting_value'] ?? '',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ]);
        }
    }
}
