<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAdmissionHistoryTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('admission_history', function (Blueprint $table) {
            $table->id(); // Primary key
            $table->engine = 'InnoDB';
            
            // Same fields as admissions table
            $table->foreignId('student_id')->constrained('students')->onDelete('cascade');
            $table->string('head_code');
            $table->string('reg_no');
            $table->string('admission_no'); // Removed 'unique' since history can have duplicates
            $table->foreignId('class_id')->constrained('classes')->onDelete('cascade');
            $table->foreignId('section_id')->constrained('sections')->onDelete('cascade');
            $table->string('session_year');
            $table->enum('status', ['active', 'completed', 'Leave']);
            $table->enum('admission_status', ['new', 'promoted', 'repeated']);
            $table->date('admission_date');
            
            // Additional fields for tracking history
            $table->foreignId('original_admission_id')->nullable()->constrained('admissions')->onDelete('set null');
            $table->timestamp('promoted_at')->nullable(); // When this record was archived
            $table->text('change_reason')->nullable(); // Optional: Reason for promotion/change
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('admission_history');
    }
}