<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('income_details', function (Blueprint $table) {
            $table->id();
            $table->engine = 'InnoDB';
            $table->foreignId('income_id');
            $table->foreignId('income_account_id');
            $table->text('description')->nullable();
            $table->double('amount', 10, 2);
            $table->enum('status', ['active', 'inactive'])->default('active');
            $table->date('date');
            $table->string('receipt_file')->nullable(); // Stores the file path of the receipt
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('income_details');
    }
};
