<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('exam_roll_numbers', function (Blueprint $table) {
            $table->id(); // Primary key (auto-incrementing BIGINT)
            
            // Foreign keys
            $table->foreignId('student_id')->constrained('students')->onDelete('cascade');
            $table->foreignId('exam_id')->constrained('exams')->onDelete('cascade');
            
            // Roll number data
            $table->text('qr_code'); // Stores QR code data
            $table->timestamp('issued_at')->useCurrent(); // Automatic timestamp
            
            // Timestamps (created_at, updated_at)
            $table->timestamps();
            
            // Composite index for better performance
            $table->unique(['student_id', 'exam_id']); // Ensures one roll number per student per exam
            $table->index('exam_id'); // Faster queries filtering by exam
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('exam_roll_numbers');
    }
};