<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('exam_schedules', function (Blueprint $table) {
            $table->id(); // Primary key (auto-incrementing BIGINT)
            
            // Foreign keys
            $table->foreignId('exam_id')->constrained('exams')->onDelete('cascade');
            $table->foreignId('class_id')->constrained('classes')->onDelete('cascade');
            $table->foreignId('subject_id')->nullable()->constrained()->onDelete('set null');
            $table->foreignId('invigilator_id')->nullable()->constrained('staff_members')->onDelete('set null');
            
            // Date fields
            $table->date('exam_date');
            
            // Additional fields
            $table->text('special_notes')->nullable();
            $table->string('academic_session')->nullable();
            
            // Timestamps
            $table->timestamps();
            
            // Optional: Indexes for better performance
            $table->index(['exam_id', 'class_id']);
            $table->index('exam_date');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('exam_schedules');
    }
};