<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('staff_salary_struct', function (Blueprint $table) {
            $table->id(); // Primary key
            $table->engine = 'InnoDB';
            $table->foreignId('staff_id');
            $table->string('head_code');
            $table->string('reg_no');
            $table->double('salary', 10, 2)->nullable();
            $table->double('b1', 10, 2)->nullable();
            $table->double('b2', 10, 2)->nullable();
            $table->double('b3', 10, 2)->nullable();
            $table->double('b4', 10, 2)->nullable();
            $table->double('b5', 10, 2)->nullable();
            $table->double('net_salary', 10, 2)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('staff_salary_struct');
    }
};
