<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAttendancesTable extends Migration
{
    public function up()
    {
        Schema::create('attendances', function (Blueprint $table) {
            $table->id();
            $table->foreignId('student_id')->constrained()->onDelete('cascade');
            $table->foreignId('class_id')->constrained('classes')->onDelete('cascade');
            $table->foreignId('section_id')->constrained('sections')->onDelete('cascade');
            $table->enum('status', ['present', 'absent', 'leave', 'half_day'])->default('present');
            $table->text('remarks')->nullable();
            $table->date('date'); // the date the attendance is marked
            $table->timestamps();

            $table->unique(['student_id', 'date']); // Ensure one attendance per student per date
        });
    }

    public function down()
    {
        Schema::dropIfExists('attendances');
    }
}
