<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('subjects', function (Blueprint $table) {
            $table->id();
            $table->engine = 'InnoDB';
            $table->string('name'); // Subject name (e.g., Mathematics)
            $table->string('code')->unique(); // Subject code (e.g., MATH101)
            $table->unsignedInteger('total_marks'); // Total marks for the subject
            $table->unsignedInteger('passing_marks'); // Passing marks threshold
            $table->timestamps(); // created_at and updated_at columns
            
            // Optional: Add index for better performance on frequently searched columns
            $table->index('name');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('subjects');
    }
};