<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up() {
        Schema::create('expense_details', function (Blueprint $table) {
            $table->id();
            $table->engine = 'InnoDB';
            $table->foreignId('expense_id')->constrained('expenses')->onDelete('cascade');
            $table->foreignId('expense_account_id')->constrained('expense_categories')->onDelete('cascade');
            $table->text('description')->nullable();
            $table->double('amount', 10, 2);
            $table->enum('status', ['active', 'inactive'])->default('active');
            $table->date('date');
            $table->string('receipt_file')->nullable(); // Stores the file path of the receipt
            $table->timestamps();
        });
    }

    public function down() {
        Schema::dropIfExists('expense_details');
    }
};

