<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up() {
        Schema::create('expenses', function (Blueprint $table) {
            $table->id();
            $table->engine = 'InnoDB';
            $table->date('date');
            $table->string('voucher_number')->unique();
            $table->text('description')->nullable();
            $table->double('amount', 10, 2);
            $table->enum('status', ['active', 'inactive'])->default('active');
            $table->timestamps();
        });
    }

    public function down() {
        Schema::dropIfExists('expenses');
    }
};
