<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateStudentCardsTemplatesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('student_cards_templates', function (Blueprint $table) {
            $table->id(); // Primary key
            $table->engine = 'InnoDB';
            $table->string('template_name'); // Template name (e.g., template_left, template_right)
            $table->string('background_color')->nullabe(); // Background color (e.g., blue, green)
            $table->string('text_color')->nullable(); // Text color (e.g., FFFFFF)
            $table->string('logo')->nullable(); // Logo file path or URL
            $table->integer('logo_width')->nullable(); // Logo width
            $table->integer('logo_height')->nullable(); // Logo height
            $table->integer('photo_width')->nullable(); // Photo width
            $table->integer('photo_height')->nullable(); // Photo height
            $table->timestamps(); // Created at and updated at timestamps
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('student_cards_templates');
    }
}