<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateStudentAssignFeeTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('student_assign_fees', function (Blueprint $table) {
            $table->id(); // Unique fee record ID (Primary Key)
            $table->engine = 'InnoDB';
            $table->foreignId('student_id')->constrained('students')->onDelete('cascade'); // Reference to the student
            $table->string('head_code');
            $table->string('reg_no');
            $table->foreignId('class_id')->constrained('classes')->onDelete('cascade'); // Reference to the class
            $table->string('academic_year'); // Academic year (e.g., "2024-2025")
            
            // Fee columns with nullable()
            $table->foreignId('admission_fee_id')->nullable()->constrained('fee_structures')->onDelete('cascade'); // Admission fee amount
            $table->foreignId('promotion_fee_id')->nullable()->constrained('fee_structures')->onDelete('cascade'); // Promotion fee amount
            $table->foreignId('scholarship_fee_id')->nullable()->constrained('fee_structures')->onDelete('cascade'); // Scholarship fee amount
            $table->foreignId('sport_fee_id')->nullable()->constrained('fee_structures')->onDelete('cascade'); // Sport fee
            $table->foreignId('tuition_fee_id')->nullable()->constrained('fee_structures')->onDelete('cascade'); // Monthly tuition fee
            $table->foreignId('lab_fee_id')->nullable()->constrained('fee_structures')->onDelete('cascade'); // Lab charges
            $table->foreignId('exam_fee_id')->nullable()->constrained('fee_structures')->onDelete('cascade'); // Examination fee
            $table->foreignId('board_fee_id')->nullable()->constrained('fee_structures')->onDelete('cascade'); // Board registration/exam fee
            $table->foreignId('entertainment_fee_id')->nullable()->constrained('fee_structures')->onDelete('cascade'); // Entertainment charges
            $table->foreignId('other_fee_id')->nullable()->constrained('fee_structures')->onDelete('cascade'); // Any other additional charges
            $table->foreignId('books_charges_id')->nullable()->constrained('fee_structures')->onDelete('cascade'); // Books and study materials charges
            $table->foreignId('annual_charges_id')->nullable()->constrained('fee_structures')->onDelete('cascade'); // Annual maintenance or other charges
            $table->foreignId('second_time_fee_id')->nullable()->constrained('fee_structures')->onDelete('cascade'); // Fee for re-examinations or additional sessions
            
            $table->timestamps(); // Record creation date and last update timestamp
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('student_assign_fees');
    }
}