<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAdmissionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('admissions', function (Blueprint $table) {
            $table->id(); // Equivalent to INT (PK)
            $table->engine = 'InnoDB';
            $table->foreignId('student_id')->constrained('students')->onDelete('cascade'); // Links to students.id
            $table->string('head_code');
            $table->string('reg_no');
            $table->string('admission_no')->unique(); // Unique admission number
            $table->foreignId('class_id')->constrained('classes')->onDelete('cascade'); // Current assigned class
            $table->foreignId('section_id')->constrained('sections')->onDelete('cascade'); // Assigned section
            $table->string('session_year'); // 2024-2025
            $table->enum('status', ['active', 'completed', 'Leave']); // ENUM type
            $table->enum('admission_status', ['new', 'promoted', 'repeated']); // ENUM type
            $table->date('admission_date'); // Date of admission
            $table->timestamps(); // created_at and updated_at timestamps
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('admissions');
    }
}