<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('students', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->id();
            $table->unsignedBigInteger('user_id')->nullable(); // Belongs to users table
            $table->string('head_code');
            $table->string('student_name');
            $table->string('father_name');
            $table->string('father_cnic');
            $table->string('email')->nullable();
            $table->enum('gender', ['Male', 'Female', 'Other']);
            $table->date('date_of_birth');
            $table->string('place_of_birth')->nullable();
            $table->string('religion')->nullable();
            $table->string('mother_name')->nullable();
            $table->text('permanent_address');
            $table->text('current_address')->nullable();
            $table->string('blood_group')->nullable();
            $table->timestamps();

            // No foreign key constraint, as Eloquent will handle relationships
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('students');
    }
};
