<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class NewStudentApplicationGuardian extends Model
{
    use HasFactory;

    protected $table = 'new_student_application_guardians';

    protected $fillable = [
        'student_id',
        'guardian_name',
        'guardian_relationship',
        'guardian_cnic',
        'primary_contact',
        'alternate_contact',
        'email',
        'status'
    ];

    // Relationship with Student
    public function student()
    {
        return $this->belongsTo(NewStudentApplication::class, 'student_id');
    }
}
