<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class NewStudentApplication extends Model
{
    use HasFactory;

    protected $table = 'new_student_applications';

    protected $fillable = [
        'full_name',
        'father_name',
        'dob',
        'gender',
        'cnic',
        'class_applying',
        'address',
        'status'
    ];

    // Relationship with Guardian
    public function NewStudentApplicationGuardian()
    {
        return $this->hasOne(NewStudentApplicationGuardian::class, 'student_id');
    }
    public function classes()
    {
        return $this->belongsTo(Classe::class, 'class_applying', 'id');
    }
}
