<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ExamSchedule extends Model
{
    // app/Models/ExamSchedule.php
    protected $fillable = [
        'exam_id', 'class_id', 'subject_id', 
        'exam_date', 'invigilator_id', 'special_notes', 'academic_session'
    ];

    public function exam()
    {
        return $this->belongsTo(Exam::class);
    }

    public function hallAssignments()
    {
        return $this->hasMany(ExamHallAssignment::class, 'exam_schedule_id');

    }

    public function class()
    {
        return $this->belongsTo(Classe::class); // Assuming Class model exists
    }

    public function subject()
    {
        return $this->belongsTo(Subject::class); // Assuming Subject model exists
    }

    public function invigilator()
    {
        return $this->belongsTo(Staff_member::class, 'invigilator_id'); // Assuming Staff model exists
    }
}
