<?php

namespace App\Http\Controllers;

use App\Models\Student;
use App\Models\Transaction_detail;
use Illuminate\Http\Request;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Support\Facades\DB;

class StudentDuesController extends Controller
{
    public function index(Request $request)
    {
        $stdList = Student::select('head_code', 'student_name', 'reg_no')->get();
        $query = Student::with(['student_classes', 'classes', 'latestAdmission'])
            ->whereHas('latestAdmission'); // Don't call get() here

    
        // 🔍 Search filter by head_code (from select)
        if ($request->has('search') && $request->search != '') {
            $query->where('head_code', $request->search);
        }

        // 📄 Entries per page (default 40)
        $perPage = $request->input('entries', 40);
        $students = $query->paginate($perPage);

        $totalDebit = 0;
        $totalCredit = 0;

        foreach ($students as $s) {
            $studentDebit = Transaction_detail::where('coa_id', $s->head_code)->sum('debit');
            $studentCredit = Transaction_detail::where('coa_id', $s->head_code)->sum('credit');

            $totalDebit += $studentDebit;
            $totalCredit += $studentCredit;

            $s->studentDebit = $studentDebit;
            $s->studentCredit = $studentCredit;
        }

        if ($request->ajax()) {
            return view('student.partialDuesStd', compact('students', 'totalDebit', 'totalCredit'))->render();
        }
        $classes  = DB::table('classes')->get();
        return view('student.stdDuesReport', compact('students','classes', 'totalDebit', 'totalCredit', 'stdList'));
    }



    public function pdfStudentDues(Request $request)
    {
        $query = Student::with(['student_classes', 'classes', 'latestAdmission'])
            ->whereHas('latestAdmission');

        // 📌 Filter by class_id if provided
        if ($request->has('class_id') && $request->class_id != '') {
            $query->whereHas('latestAdmission', function ($q) use ($request) {
                $q->where('class_id', $request->class_id);
            });
        }

        // 🔍 Filter by student if selected
        if ($request->has('search') && $request->search != '') {
            $query->where('head_code', $request->search);
        }

        $students = $query->get(); // 👈 No pagination for PDF

        $totalDebit = 0;
        $totalCredit = 0;

        foreach ($students as $s) {
            $studentDebit = Transaction_detail::where('coa_id', $s->head_code)->sum('debit');
            $studentCredit = Transaction_detail::where('coa_id', $s->head_code)->sum('credit');

            $totalDebit += $studentDebit;
            $totalCredit += $studentCredit;

            $s->studentDebit = $studentDebit;
            $s->studentCredit = $studentCredit;
        }

        $pdf = Pdf::loadView('student.pdfStudentDues', [
            'students' => $students,
            'totalDebit' => $totalDebit,
            'totalCredit' => $totalCredit,
        ]);

        return $pdf->download('student-dues-report.pdf');
    }

}
