<?php

namespace App\Http\Controllers;

use App\Models\Staff_member;
use App\Models\Staff_salary_struct;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

// use Illuminate\Support\Facades\Request;

class SalaryStructController extends Controller
{
    public function getStruct($head_code)
    {
        $staff = Staff_member::where('head_code', $head_code)->first();
        $s_St = Staff_salary_struct::where('head_code', $head_code)->first();

        return response()->json([
            'cnic'   => $staff->cnic ?? '',
            'reg_no' => $staff->registration_no ?? '',
            'salary' => $staff->salary ?? 0,
            'b1'     => $s_St->b1 ?? 0,
            'b2'     => $s_St->b2 ?? 0,
            'b3'     => $s_St->b3 ?? 0,
            'b4'     => $s_St->b4 ?? 0,
            'b5'     => $s_St->b5 ?? 0,
        ]);
    }
   
    public function update(Request $request)
    {
        try {

            $headCode = $request->input('emp_name_st');
            $salary = $request->input('salary');
            $b1 = $request->input('b1', 0);
            $b2 = $request->input('b2', 0);
            $b3 = $request->input('b3', 0);
            $b4 = $request->input('b4', 0);
            $b5 = $request->input('b5', 0);

            // Find the staff member by head_code
            $staff = Staff_member::where('head_code', $headCode)->first();

            // Update or create the salary structure
            Staff_salary_struct::updateOrCreate(
                ['head_code' => $headCode],
                [
                    'staff_id'  => $staff->id,
                    'head_code' => $headCode,
                    'reg_no'    => $staff->registration_no,
                    'salary'    => $salary ?? 0,
                    'b1'        => $b1 ?? 0,
                    'b2'        => $b2 ?? 0,
                    'b3'        => $b3 ?? 0,
                    'b4'        => $b4 ?? 0,
                    'b5'        => $b5 ?? 0,
                ]
            );

            // Update salary in Staff table
            $staff->salary = $salary;
            $staff->save();

            return redirect()->route('staff.salary')->with('success', 'Salary Update successfully!');
        } catch (\Illuminate\Validation\ValidationException $e) {
            // Handle form validation errors
            return redirect()->back()->withErrors($e->validator)->withInput();
        } catch (\Exception $e) {
            // Handle unexpected errors
            return redirect()->back()->withErrors(['error' => 'Something went wrong: ' . $e->getMessage()]);
        }
    }

    public function  updateSalaryRow(Request $request)
    {
        try {

            $headCode = $request->input('m_HeadCode');
            $salary = $request->input('m_Salary');
            $b1 = $request->input('m_b1', 0);
            $b2 = $request->input('m_b2', 0);
            $b3 = $request->input('m_b3', 0);
            $b4 = $request->input('m_b4', 0);
            $b5 = $request->input('m_b5', 0);

            // Find the staff member by head_code
            $staff = Staff_member::where('head_code', $headCode)->first();

            // Update or create the salary structure
            Staff_salary_struct::updateOrCreate(
                ['head_code' => $headCode],
                [
                    'staff_id'  => $staff->id,
                    'head_code' => $headCode,
                    'reg_no'    => $staff->registration_no,
                    'salary'    => $salary ?? 0,
                    'b1'        => $b1 ?? 0,
                    'b2'        => $b2 ?? 0,
                    'b3'        => $b3 ?? 0,
                    'b4'        => $b4 ?? 0,
                    'b5'        => $b5 ?? 0,
                ]
            );

            // Update salary in Staff table
            $staff->salary = $salary;
            $staff->save();

            return redirect()->route('staff.salary')->with('success', 'Salary Update successfully!');
        } catch (\Illuminate\Validation\ValidationException $e) {
            // Handle form validation errors
            return redirect()->back()->withErrors($e->validator)->withInput();
        } catch (\Exception $e) {
            // Handle unexpected errors
            return redirect()->back()->withErrors(['error' => 'Something went wrong: ' . $e->getMessage()]);
        }
    }
}
