<?php

namespace App\Http\Controllers;

use App\Models\Job_application;
use App\Models\Job_position;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Barryvdh\DomPDF\Facade\Pdf;

class JobAppController extends Controller
{
    // job application form
    public function create()
    {
        $jobPositions = Job_position::where('status', 'open')->get();

        return view('jobApplication.jobAppForm', compact('jobPositions'));
    }

    //All job application
    public function index(Request $request, $id = 0)
    {
        $query = Job_application::query();
        if ($id != 0) {
            $query->where('job_id', $id);
        }

        if ($request->filled('search_query')) {
            $search = $request->search_query;
            $query->where(function ($q) use ($search) {
                $q->where('applicant_name', 'like', "%$search%")
                    ->orWhere('father_name', 'like', "%$search%")
                    ->orWhere('email', 'like', "%$search%")
                    ->orWhere('phone', 'like', "%$search%")
                    ->orWhere('qualification', 'like', "%$search%")
                    ->orWhere('applied_position', 'like', "%$search%")
                    ->orWhere('apply_type', 'like', "%$search%")
                    ->orWhere('applied_date', 'like', "%$search%")
                    ->orWhere('application_status', 'like', "%$search%");
            });
        }

        // Status counts (should reflect filters if needed)
        $all = ($id == 0) ? Job_application::count() : Job_application::where('job_id', $id)->count();
        $accepted = ($id == 0) ? Job_application::where('application_status', 'accepted')->count() : Job_application::where('job_id', $id)->where('application_status', 'accepted')->count();
        $rejected = ($id == 0) ? Job_application::where('application_status', 'rejected')->count() : Job_application::where('job_id', $id)->where('application_status', 'rejected')->count();
        $pending = ($id == 0) ? Job_application::where('application_status', 'pending')->count() : Job_application::where('job_id', $id)->where('application_status', 'pending')->count();

        $applications = $query->paginate(10);

        if ($request->ajax()) {
            return view('jobApplication.partialJobApp', compact('applications'))->render();
        }
        return view('jobApplication.allJobApp', compact('all', 'accepted', 'rejected', 'pending', 'applications'));
    }

    //Accepted job application
    public function indexAccepted(Request $request, $id = 0)
    {
        $query = Job_application::where('application_status', 'accepted');
        if ($id != 0) {
            $query->where('job_id', $id);
        }

        if ($request->filled('search_query')) {
            $search = $request->search_query;
            $query->where(function ($q) use ($search) {
                $q->where('applicant_name', 'like', "%$search%")
                    ->orWhere('father_name', 'like', "%$search%")
                    ->orWhere('email', 'like', "%$search%")
                    ->orWhere('phone', 'like', "%$search%")
                    ->orWhere('qualification', 'like', "%$search%")
                    ->orWhere('applied_position', 'like', "%$search%")
                    ->orWhere('apply_type', 'like', "%$search%")
                    ->orWhere('applied_date', 'like', "%$search%")
                    ->orWhere('application_status', 'like', "%$search%");
            });
        }

        // Status counts (should reflect filters if needed)
        $all = ($id == 0) ? Job_application::count() : Job_application::where('job_id', $id)->count();
        $accepted = ($id == 0) ? Job_application::where('application_status', 'accepted')->count() : Job_application::where('job_id', $id)->where('application_status', 'accepted')->count();
        $rejected = ($id == 0) ? Job_application::where('application_status', 'rejected')->count() : Job_application::where('job_id', $id)->where('application_status', 'rejected')->count();
        $pending = ($id == 0) ? Job_application::where('application_status', 'pending')->count() : Job_application::where('job_id', $id)->where('application_status', 'pending')->count();

        $applications = $query->paginate(10);

        if ($request->ajax()) {
            return view('jobApplication.partialAcceptedJob', compact('applications'))->render();
        }
        return view('jobApplication.acceptedJob', compact('all', 'accepted', 'rejected', 'pending', 'applications'));
    }

    //Pending job application
    public function indexPending(Request $request, $id = 0)
    {
        $query = Job_application::where('application_status', 'pending');
        if ($id != 0) {
            $query->where('job_id', $id);
        }

        if ($request->filled('search_query')) {
            $search = $request->search_query;
            $query->where(function ($q) use ($search) {
                $q->where('applicant_name', 'like', "%$search%")
                    ->orWhere('father_name', 'like', "%$search%")
                    ->orWhere('email', 'like', "%$search%")
                    ->orWhere('phone', 'like', "%$search%")
                    ->orWhere('qualification', 'like', "%$search%")
                    ->orWhere('applied_position', 'like', "%$search%")
                    ->orWhere('apply_type', 'like', "%$search%")
                    ->orWhere('applied_date', 'like', "%$search%")
                    ->orWhere('application_status', 'like', "%$search%");
            });
        }

        // Status counts (should reflect filters if needed)
        $all = ($id == 0) ? Job_application::count() : Job_application::where('job_id', $id)->count();
        $accepted = ($id == 0) ? Job_application::where('application_status', 'accepted')->count() : Job_application::where('job_id', $id)->where('application_status', 'accepted')->count();
        $rejected = ($id == 0) ? Job_application::where('application_status', 'rejected')->count() : Job_application::where('job_id', $id)->where('application_status', 'rejected')->count();
        $pending = ($id == 0) ? Job_application::where('application_status', 'pending')->count() : Job_application::where('job_id', $id)->where('application_status', 'pending')->count();

        $applications = $query->paginate(10);

        if ($request->ajax()) {
            return view('jobApplication.partialPendingJob', compact('applications'))->render();
        }
        return view('jobApplication.pendingJob', compact('all', 'accepted', 'rejected', 'pending', 'applications'));
    }


    //Rejected job application
    public function indexRejected(Request $request, $id = 0)
    {
        $query = Job_application::where('application_status', 'rejected');
        if ($id != 0) {
            $query->where('job_id', $id);
        }

        if ($request->filled('search_query')) {
            $search = $request->search_query;
            $query->where(function ($q) use ($search) {
                $q->where('applicant_name', 'like', "%$search%")
                    ->orWhere('father_name', 'like', "%$search%")
                    ->orWhere('email', 'like', "%$search%")
                    ->orWhere('phone', 'like', "%$search%")
                    ->orWhere('qualification', 'like', "%$search%")
                    ->orWhere('applied_position', 'like', "%$search%")
                    ->orWhere('apply_type', 'like', "%$search%")
                    ->orWhere('applied_date', 'like', "%$search%")
                    ->orWhere('application_status', 'like', "%$search%");
            });
        }

        // Status counts (should reflect filters if needed)
        $all = ($id == 0) ? Job_application::count() : Job_application::where('job_id', $id)->count();
        $accepted = ($id == 0) ? Job_application::where('application_status', 'accepted')->count() : Job_application::where('job_id', $id)->where('application_status', 'accepted')->count();
        $rejected = ($id == 0) ? Job_application::where('application_status', 'rejected')->count() : Job_application::where('job_id', $id)->where('application_status', 'rejected')->count();
        $pending = ($id == 0) ? Job_application::where('application_status', 'pending')->count() : Job_application::where('job_id', $id)->where('application_status', 'pending')->count();

        $applications = $query->paginate(10);

        if ($request->ajax()) {
            return view('jobApplication.partialRejectedJob', compact('applications'))->render();
        }
        return view('jobApplication.rejectedJob', compact('all', 'accepted', 'rejected', 'pending', 'applications'));
    }

    // job application store

    public function store(Request $request)
    {
        // Validate the form data
        $request->validate([
            'job_position'       => 'required|integer|exists:job_positions,id',
            'full_name'          => 'required|string|max:255',
            'email'              => 'required|email|max:255',
            'complete_address'   => 'required|string',
            'father_name'        => 'required|string|max:255',
            'primary_contact_no' => 'required|string|max:20',
            'cv_resume'          => 'required|file|mimes:pdf,doc,docx|max:10240', // 10MB max
        ]);

        // Start a database transaction
        DB::beginTransaction();

        try {
            // Handle file upload
            if ($request->hasFile('cv_resume')) {
                $file     = $request->file('cv_resume');
                $fileName = time() . '_' . $file->getClientOriginalName();
                $filePath = $file->storeAs('cv_resumes', $fileName, 'public'); // Store in 'storage/app/public/cv_resumes'
            } else {
                throw new \Exception('CV/Resume file is required.');
            }

            // Store the data in the database
            Job_application::create([
                'job_id'           => $request->job_position,
                'applicant_name'   => $request->full_name,
                'experience'       => $request->experience,
                'qualification'    => $request->qualification,
                'email'            => $request->email,
                'address'          => $request->complete_address,
                'father_name'      => $request->father_name,
                'applied_position' => $request->applied_position,
                'phone'            => $request->primary_contact_no,
                'resume'           => $filePath,              // Save the file path
                'cover_letter'     => $request->cover_letter, // Save the cover_letter
                'apply_type'       => 'offline',
            ]);

            DB::commit();

            return redirect()->route('job_application')
                ->with('success', 'Job application submitted successfully!');
        } catch (\Exception $e) {
            DB::rollBack();

            // Delete the uploaded file if it exists
            if (isset($filePath)) {
                Storage::disk('public')->delete($filePath);
            }

            // Redirect back with an error message
            return redirect()->route('job_application_create')
                ->with('error', 'An error occurred: ' . $e->getMessage());
        }
    }


    public function status($id, $status)
    {
        $application                     = Job_application::find($id);
        $application->application_status = $status;
        $application->save();
        return redirect()->route('job_application')->with('success', 'Status Change successfully');
        dd($id . " " . $status);
    }


 

    public function pdfAllJobApp(Request $request)
    {
        $applications = Job_application::query();

        if ($request->filled('search_query')) {
            $search = $request->search_query;
            $applications->where(function ($q) use ($search) {
                $q->where('applicant_name', 'like', "%$search%")
                    ->orWhere('father_name', 'like', "%$search%")
                    ->orWhere('email', 'like', "%$search%")
                    ->orWhere('phone', 'like', "%$search%")
                    ->orWhere('qualification', 'like', "%$search%")
                    ->orWhere('applied_position', 'like', "%$search%")
                    ->orWhere('apply_type', 'like', "%$search%")
                    ->orWhere('applied_date', 'like', "%$search%")
                    ->orWhere('application_status', 'like', "%$search%");
            });
        }

        $applications = $applications->get();

        $pdf = Pdf::loadView('jobApplication.pdfAllJob', compact('applications'))->setPaper('A4', 'landscape');
        return $pdf->download('allJobApplicationPdf.pdf');
    }


    public function pdfAcceptedJobApp(Request $request)
    {
        $applications = Job_application::query();

        // Filter only accepted applications
        if ($request->filled('search_query')) {
            $search = $request->search_query;

            $applications->where(function ($q) use ($search) {
                $q->where('applicant_name', 'like', "%$search%")
                    ->orWhere('father_name', 'like', "%$search%")
                    ->orWhere('email', 'like', "%$search%")
                    ->orWhere('phone', 'like', "%$search%")
                    ->orWhere('qualification', 'like', "%$search%")
                    ->orWhere('applied_position', 'like', "%$search%")
                    ->orWhere('apply_type', 'like', "%$search%")
                    ->orWhere('applied_date', 'like', "%$search%");
            });

            // Optional: also allow filtering by status if included in search
            $applications->where('application_status', 'accepted');
        } else {
            $applications->where('application_status', 'accepted');
        }

        $applications = $applications->get();

        $pdf = Pdf::loadView('jobApplication.pdfAcceptedJob', compact('applications'))
            ->setPaper('A4', 'landscape');

        return $pdf->download('accepted_applications.pdf');
    }

    public function pdfPendingJobApp(Request $request)
    {
        $applications = Job_application::query();

        // Filter only accepted applications
        if ($request->filled('search_query')) {
            $search = $request->search_query;

            $applications->where(function ($q) use ($search) {
                $q->where('applicant_name', 'like', "%$search%")
                    ->orWhere('father_name', 'like', "%$search%")
                    ->orWhere('email', 'like', "%$search%")
                    ->orWhere('phone', 'like', "%$search%")
                    ->orWhere('qualification', 'like', "%$search%")
                    ->orWhere('applied_position', 'like', "%$search%")
                    ->orWhere('apply_type', 'like', "%$search%")
                    ->orWhere('applied_date', 'like', "%$search%");
            });

            // Optional: also allow filtering by status if included in search
            $applications->where('application_status', 'pending');
        } else {
            $applications->where('application_status', 'pending');
        }

        $applications = $applications->get();

        $pdf = Pdf::loadView('jobApplication.pdfPendingJob', compact('applications'))
            ->setPaper('A4', 'landscape');

        return $pdf->download('pending_applications.pdf');
    }

    public function pdfRejectedJobApp(Request $request)
    {
        $applications = Job_application::query();

        // Filter only accepted applications
        if ($request->filled('search_query')) {
            $search = $request->search_query;

            $applications->where(function ($q) use ($search) {
                $q->where('applicant_name', 'like', "%$search%")
                    ->orWhere('father_name', 'like', "%$search%")
                    ->orWhere('email', 'like', "%$search%")
                    ->orWhere('phone', 'like', "%$search%")
                    ->orWhere('qualification', 'like', "%$search%")
                    ->orWhere('applied_position', 'like', "%$search%")
                    ->orWhere('apply_type', 'like', "%$search%")
                    ->orWhere('applied_date', 'like', "%$search%");
            });

            // Optional: also allow filtering by status if included in search
            $applications->where('application_status', 'rejected');
        } else {
            $applications->where('application_status', 'rejected');
        }

        $applications = $applications->get();

        $pdf = Pdf::loadView('jobApplication.pdfRejectedJob', compact('applications'))
            ->setPaper('A4', 'landscape');

        return $pdf->download('rejected_applications.pdf');
    }
}
