<?php

namespace App\Http\Controllers;

use App\Models\Classe;
use App\Models\Fee_structure;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Barryvdh\DomPDF\Facade\Pdf;

class FeeStructureController extends Controller
{
    public function show()
    {
        $classes    = Classe::all();
        $structures = Fee_structure::with('class')->select('class_id')->groupBY('class_id')->paginate(10);
        $amounts    = Fee_structure::with('class')->get();
        return view('stdFeeMgt.fee-structure', compact('classes', 'structures', 'amounts'));
    }
  

    public function pdfStudentFeeStructure()
    {
        $structures = \App\Models\Fee_structure::with('class')
            ->select('class_id')
            ->groupBy('class_id')
            ->get();

        $amounts = \App\Models\Fee_structure::with('class')->get();

        $pdf = Pdf::loadView('stdFeeMgt.pdfStudentFeeStructure', compact('structures', 'amounts'))->setPaper('a4', 'landscape');
        return $pdf->download('student-fee-structure.pdf');
    }



    public function store(Request $request)
    {

        if ($request->class_id == null) {
            return redirect()->back()->with('error', 'Please select class');
        }

        DB::beginTransaction();

        try {
            $request->validate([
                'class_id' => 'required|exists:classes,id',
                'fee_type' => 'required|array',
            ]);

            $classId  = $request->class_id;
            $feeTypes = $request->input('fee_type');

            $currentYear  = date('Y');                       // Get the current year (e.g., 2025)
            $nextYear     = date('Y', strtotime('+1 year')); // Get the next year (e.g., 2026)
            $academicYear = $currentYear . '-' . $nextYear;  // Combine them into "2025-2026"

            foreach ($feeTypes as $type => $amount) {
                if ($amount == null) {
                    // if fee_amout is null then check that fee_type is already exist if exit don't insert
                    $fee_structure = Fee_structure::where('class_id', $classId)
                        ->where('fee_type', $type)
                        ->where('year', $academicYear)
                        ->first();
                    if ($fee_structure) {
                        // Fee structure already exists, so skip the insertion
                        continue;
                    }
                    $amount = 0;
                    Fee_structure::updateOrCreate(
                        [
                            'class_id' => $classId,
                            'fee_type' => $type,
                            'year' => $academicYear,
                        ],
                        [
                            'amount' => $amount,
                        ]
                    );
                } else {

                    Fee_structure::updateOrCreate(
                        [
                            'class_id' => $classId,
                            'fee_type' => $type,
                            'year' => $academicYear,
                        ],
                        [
                            'amount' => $amount,
                        ]
                    );
                }
            }
            DB::commit();
            return redirect()->back()->with('success', 'Fee structure created successfully!');
        } catch (Exception $e) {
            DB::rollBack();
            return redirect()->back()->with('error', 'Failed to create fee structure. Please try again.' . $e);
        }
    }

    // show edit form
    public function edit($classId)
    {
        $feeStructure = Fee_structure::where('class_id', $classId)->get();
        $data = [
            'class_id' => $classId,
            'fee_type' => [
                'admission_fee'     => $feeStructure->where('fee_type', 'admission_fee')->first()->amount ?? null,
                'promotion_fee'     => $feeStructure->where('fee_type', 'promotion_fee')->first()->amount ?? null,
                'tuition_fee'       => $feeStructure->where('fee_type', 'tuition_fee')->first()->amount ?? null,
                'lab_fee'           => $feeStructure->where('fee_type', 'lab_fee')->first()->amount ?? null,
                'exam_fee'          => $feeStructure->where('fee_type', 'exam_fee')->first()->amount ?? null,
                'board_fee'         => $feeStructure->where('fee_type', 'board_fee')->first()->amount ?? null,
                'entertainment_fee' => $feeStructure->where('fee_type', 'entertainment_fee')->first()->amount ?? null,
                'other_fee'         => $feeStructure->where('fee_type', 'other_fee')->first()->amount ?? null,
                'books_charges'     => $feeStructure->where('fee_type', 'books_charges')->first()->amount ?? null,
                'annual_charges'    => $feeStructure->where('fee_type', 'annual_charges')->first()->amount ?? null,
                'second_time_fee'   => $feeStructure->where('fee_type', 'second_time_fee')->first()->amount ?? null,
            ],
        ];

        return response()->json($data);
    }


    public function update(Request $request)
    {
        $request->validate([
            'class_id' => 'required|exists:classes,id',
            'fee_type' => 'required|array',
        ]);

        $classId  = $request->input('class_id');
        $feeTypes = $request->input('fee_type');

        foreach ($feeTypes as $type => $amount) {
            Fee_structure::updateOrCreate(
                ['class_id' => $classId, 'fee_type' => $type],
                ['amount' => $amount]
            );
        }

        return redirect()->back()->with('success', 'Fee structure updated successfully!');
    }
}
