<?php
namespace App\Http\Controllers;
use App\Models\Student;
use App\Models\Staff_member as Staff;
use Illuminate\Support\Facades\Response;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Barryvdh\DomPDF\Facade\Pdf;
use App\Models\School_setting;
use Illuminate\Support\Facades\Storage;
use App\Models\School_session;
use Illuminate\Support\Facades\Log;
class DocumentController extends Controller
{
    public function show($path)
    {
        $fullPath = storage_path('app/public/' . $path);

        if (! file_exists($fullPath)) {
            abort(404); // or return a default image
        }

        return response()->file($fullPath);
    }
    public function show_logo($path)
    {
        $fullPath = storage_path('app/public/' . $path);

        if (! file_exists($fullPath)) {
            // fallback to public/assets/logo.svg if file not found
            $defaultPath = public_path('assets/logo.svg');

            if (file_exists($defaultPath)) {
                return response()->file($defaultPath);
            }

            abort(404); // fallback also not found
        }

        return response()->file($fullPath);
    }
    public function staff_images($filename)
    {
        $path = storage_path('app/public/' . $filename);

        if (! file_exists($path)) {
            abort(404);
        }

        return response()->file($path);
    }

    public function qr_codes($filename)
    {
        $path = storage_path('app/public/' . $filename);

        if (! file_exists($path)) {
            abort(404);
        }

        return response()->file($path);
    }

    public function downloadStudentView( Request $request)
    {
        $search = $request->input('search'); 
        $student = Student::where('status', 'active')
             ->when($search, function ($query, $search) {
                     $query->where('student_name', 'like', "%{$search}%")
                    ->orWhere('email', 'like', "%{$search}%") 
                    ->orWhere('reg_no', 'like', "%{$search}%") 
                    ->orWhere('father_name', 'like', "%{$search}%");
                 })->get();
           
        

     
          //  dd($student);
       return view('documents.student_view', compact('student'));
    }

    public function showStudentDocuments($id){
        $studentId = $id; // Store the student ID for later use
        $student = Student::with(['documents', 'classes', 'sections'])->findOrFail($id);
        $studentExams = DB::table('student_marks')
            ->join('exams', 'student_marks.exam', '=', 'exams.id')
            ->join('exam_schedules', 'student_marks.exam', '=', 'exam_schedules.exam_id')
            ->join('subjects', 'student_marks.subject', '=', 'subjects.id')
            ->where('student_marks.student_id', $studentId)
            ->select(
                'exams.id as exam_id',
                'exams.title as exam_title',
                'exams.type',
                'exams.notes',
                'exams.created_at',
                'exam_schedules.academic_session',
                'subjects.name as subject_name',
                'student_marks.marks'
            )
            ->distinct()
            ->get();

            return view('documents.student.documents', compact('student','studentExams', 'studentId'));
    }
    public function downloadStaffView(Request $request)
    {
        $search = $request->input('search');

        $staff = Staff::where('status', 'active')
            ->when($search, function ($query, $search) {
                $query->where(function ($q) use ($search) {
                    $q->where('full_name', 'like', "%{$search}%")
                    ->orWhere('email', 'like', "%{$search}%")
                    ->orWhere('cnic', 'like', "%{$search}%")
                    ->orWhere('registration_no', 'like', "%{$search}%");
                });
            })
            ->get();

        return view('documents.staff_view', compact('staff', 'search'));
    }

    public function showStudentExams($studentId)
{
    $studentExams = DB::table('exam_hall_assignments AS eha')
        ->join('exams', 'eha.exam_id', '=', 'exams.id')
        ->join('exam_schedules', 'eha.exam_schedule_id', '=', 'exam_schedules.id')
        ->where('eha.student_id', $studentId)
        ->select(
            'exams.id as exam_id',
            'exams.title as exam_title',
            'exams.type',
            'exams.notes',
            'exams.created_at',
            'exam_schedules.academic_session'
        )
        ->distinct()
        ->get();

    return view('documents.students.exam_summary', compact('studentExams', 'studentId'));
}

public function generateDMC(Request $request, $studentId, $examId)
{

    $student = Student::with('latestAdmission')->find($studentId);

    if (!$student) {
        return redirect()->back()->with('error', 'Student not found.');
    }
   try {
            $dmcData = DB::table('student_marks as sm')
                ->join('students as s', 'sm.student_id', '=', 's.id')
                ->join('admissions as a', 's.id', '=', 'a.student_id')
                ->join('subjects as sub', 'sm.subject', '=', 'sub.id')
                ->join('exams as e', 'sm.exam', '=', 'e.id')
                ->where('sm.student_id', $studentId)
                ->where('sm.exam', $examId)
                ->where('a.status', 'active')
                ->select(
                    's.student_name', 's.father_name', 's.gender', 's.date_of_birth',
                    's.place_of_birth', 's.religion', 's.mother_name', 's.permanent_address',
                    'a.reg_no', 'a.admission_no', 'a.class_id', 'a.section_id', 'a.roll_number',
                    'e.title as exam_name', 'sub.name as subject_name', 'sm.marks'
                )
                ->orderBy('sub.name')
                ->get();
          
            if ($dmcData->isEmpty()) {
                return redirect()->back()->with('error', 'No marks data found.');
            }

            

            $class = DB::table('classes')->find($dmcData[0]->class_id);
            $section = DB::table('sections')->find($dmcData[0]->section_id);
            $class_name = $class->name ?? 'N/A';
            $section_name = $section->name ?? 'N/A';

            $subjectNames = $dmcData->pluck('subject_name')->unique()->toArray();
            $subjectDetails = DB::table('subjects')
                ->whereIn('name', $subjectNames)
                ->get()
                ->keyBy('name');

            $issue_date = $request->issue_date ?? now()->format('Y-m-d');
            $schoolName = School_setting::where('setting_key', 'school_name')->value('setting_value');
            // $schoolLogo = School_setting::where('setting_key', 'school_logo')->value('setting_value');
            $logo = School_setting::where('setting_key', 'school_logo')->first();
              $logoBase64 = null;
            if ($logo && $logo->setting_value) {

            $setting_value = trim($logo->setting_value);
                $path = storage_path('app/public/' . $setting_value);

                if (file_exists($path)) {
                    $type = pathinfo($path, PATHINFO_EXTENSION);
                    $data = file_get_contents($path);
                    $logoBase64 = 'data:image/' . $type . ';base64,' . base64_encode($data);
                }
                // use $logoBase64 in <img src="..."> for HTML or PDF
            } 
            $examControllerSign = School_setting::where('setting_key', 'exam_controller_sign')->first();
            $exam_sign_Base64 = null;
            if ($examControllerSign && $examControllerSign->setting_value) {

            $setting_value = trim($examControllerSign->setting_value);
                $path = storage_path('app/public/' . $setting_value);

                if (file_exists($path)) {
                    $type = pathinfo($path, PATHINFO_EXTENSION);
                    $data = file_get_contents($path);
                    $exam_sign_Base64 = 'data:image/' . $type . ';base64,' . base64_encode($data);
                }
                // use $logoBase64 in <img src="..."> for HTML or PDF
            } 
  
            $schoolAddress = School_setting::where('setting_key', 'school_address')->value('setting_value');
            $schoolContact = School_setting::where('setting_key', 'phone_number')->value('setting_value');
            $schoolEmail = School_setting::where('setting_key', 'email')->value('setting_value');
            $school_session = School_session::find($request->session)?->session_year ?? 'N/A';

            $pdf = Pdf::loadView('dmc.show', compact(
                'dmcData', 'schoolName','logoBase64','exam_sign_Base64', 'schoolAddress', 'schoolContact', 'schoolEmail',
                'school_session', 'class_name', 'section_name', 'subjectDetails', 'issue_date','examControllerSign'
            ))->setPaper('A4', 'portrait')->setOptions(['defaultFont' => 'sans-serif']);

            // Save PDF
            $fileName = 'DMC_' . $studentId . '.pdf';

            // Create directory if it doesn't exist
            Storage::disk('public')->makeDirectory('dmcs');

            // Save the PDF to the storage/app/public/dmcs/ folder
            $pdf->save(storage_path('app/public/dmcs/' . $fileName));

            // Commit DB transaction
            DB::commit();
            // Return the file for download (set deleteFileAfterSend to true if needed)
            return response()->download(storage_path('app/public/dmcs/' . $fileName))->deleteFileAfterSend(false);
        } catch (\Exception $e) {
            DB::rollBack();
            return redirect()->back()->with('error', 'Error generating DMC: ' . $e->getMessage());
        }
   }
   

}
