<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Classe;
use App\Models\Section;
use App\Models\Student;
use App\Models\Exam;
use App\Models\School_session;
use App\Models\Student_mark;
use Barryvdh\DomPDF\Facade\Pdf;
use App\Models\School_setting;
use Illuminate\Support\Facades\Storage;
use ZipArchive;

class DmcController extends Controller
{
    
    
    public function index()
    {
        // Logic to display the DMC (Detailed Marks Card) page
        $classes = \App\Models\Classe::all();
        $sections = \App\Models\Section::all();
        $subjects = \App\Models\Subject::all();
        $exams = \App\Models\Exam::all();
        $sessions = \App\Models\School_session::all();
        $students = '';
        return view('dmc.index', compact('classes', 'sections','subjects','exams','sessions','students'));
    }
 public function getStudents()
{
    $classes = \App\Models\Classe::all();
    $sections = \App\Models\Section::all();
    $subjects = \App\Models\Subject::all();
    $exams = \App\Models\Exam::all();
    $sessions = \App\Models\School_session::all();

    $selectedClass = request()->input('class');
    $selectedSection = request()->input('section');
    $selectedSubject = request()->input('subject');
    $selectedExam = request()->input('exam');
    $selectedSession = request()->input('school_session');

    $students = \App\Models\Student::whereHas('latestAdmission', function ($query) use ($selectedClass, $selectedSection) {
        $query->where('class_id', $selectedClass)
              ->where('section_id', $selectedSection);
    })->get();

    return view('dmc.index', compact(
        'classes', 'sections','subjects','exams','sessions','students',
        'selectedClass', 'selectedSection', 'selectedSubject', 'selectedExam', 'selectedSession'
    ));
}


   

    public function download($id)
    {
        // Logic to download the DMC as a PDF or other format
        return response()->download(storage_path("app/dmc/{$id}.pdf"));
    }
     
    public function store(Request $request)
    {
        $studentIds = $request->student_id;
        $marks = $request->marks;

        $class = $request->class;
        $section = $request->section;
        $subject = $request->subject;
        $exam = $request->exam;
        $session = $request->school_session;

       foreach ($studentIds as $index => $studentId) {
            DB::table('student_marks')->updateOrInsert(
                [
                    'student_id'     => $studentId,
                    'class'          => $class,
                    'section'        => $section,
                    'subject'        => $subject,
                    'exam'           => $exam,
                    'school_session' => $session,
                ],
                [
                    'marks'      => $marks[$index],
                    'updated_at' => now(),
                    'created_at' => now(), // optional; will only apply on insert
                ]
            );
        }

        return redirect()->route('dmc.index')->with('success', 'Marks submitted successfully.');
     }
   
    
    public function generate()
    {
        // Logic to generate a DMC for a specific student
        // This could involve fetching student data, marks, etc.
        $classes = \App\Models\Classe::all();
        $sections = \App\Models\Section::all();
        $students = \App\Models\Student::all();
        $exams = \App\Models\Exam::all();
        $sessions = \App\Models\School_session::all();
        return view('dmc.generate', compact('classes', 'sections', 'students', 'exams', 'sessions'));
    }
   public function generateDmc(Request $request)
{
        $request->merge([
        'student' => $request->input('student_id'),
    ]);


      $request->validate([
        // 'student' => 'required_if:feeMode,single|exists:students,id',
        'class' => 'required_if:feeMode,class|exists:classes,id',
        'section' => 'required_if:feeMode,class|exists:sections,id',
        'exam' => 'required|exists:exams,id',
        'session' => 'required|exists:school_sessions,id',
        'issue_date' => 'nullable|date',
    ]);  
    $feeMode = $request->feeMode;
    DB::beginTransaction();


    $schoolName = School_setting::where('setting_key', 'school_name')->value('setting_value');
    // $schoolLogo = School_setting::where('setting_key', 'school_logo')->value('setting_value');
    $logo = School_setting::where('setting_key', 'school_logo')->first();

    $logoBase64 = null;
    if ($logo && $logo->setting_value) {

    $setting_value = trim($logo->setting_value);
        $path = storage_path('app/public/' . $setting_value);

        if (file_exists($path)) {
            $type = pathinfo($path, PATHINFO_EXTENSION);
            $data = file_get_contents($path);
            $logoBase64 = 'data:image/' . $type . ';base64,' . base64_encode($data);
        }
        // use $logoBase64 in <img src="..."> for HTML or PDF
    } 
 
     
   // $schoolLogo = $schoolLogo ? url('school-logo/' . $schoolLogo) : asset('assets/logo.png');
    $examControllerSign = School_setting::where('setting_key', 'exam_controller_sign')->first();
    $exam_sign_Base64 = null;
    if ($examControllerSign && $examControllerSign->setting_value) {

    $setting_value = trim($examControllerSign->setting_value);
        $path = storage_path('app/public/' . $setting_value);

        if (file_exists($path)) {
            $type = pathinfo($path, PATHINFO_EXTENSION);
            $data = file_get_contents($path);
            $exam_sign_Base64 = 'data:image/' . $type . ';base64,' . base64_encode($data);
        }
        // use $logoBase64 in <img src="..."> for HTML or PDF
    } 

   // $examControllerSign = $examControllerSign ? url('school-logo/' . $examControllerSign) : '';
  
    $schoolAddress = School_setting::where('setting_key', 'school_address')->value('setting_value');
    $schoolContact = School_setting::where('setting_key', 'phone_number')->value('setting_value');
    $schoolEmail = School_setting::where('setting_key', 'email')->value('setting_value');
    $school_session = School_session::find($request->session)?->session_year ?? 'N/A';
   
    try {
        if ($feeMode == 'single') {
            $student = Student::with('latestAdmission')->find($request->student_id);
            $studentId = $request->student_id;
            $examId = $request->exam;

            $dmcData = DB::table('student_marks as sm')
                ->join('students as s', 'sm.student_id', '=', 's.id')
                ->join('admissions as a', 's.id', '=', 'a.student_id')
                ->join('subjects as sub', 'sm.subject', '=', 'sub.id')
                ->join('exams as e', 'sm.exam', '=', 'e.id')
                ->where('sm.student_id', $studentId)
                ->where('sm.exam', $examId)
                ->where('a.status', 'active')
                ->select(
                    's.student_name', 's.father_name', 's.gender', 's.date_of_birth',
                    's.place_of_birth', 's.religion', 's.mother_name', 's.permanent_address',
                    'a.reg_no', 'a.admission_no', 'a.class_id', 'a.section_id', 'a.roll_number',
                    'e.title as exam_name', 'sub.name as subject_name', 'sm.marks'
                )
                ->orderBy('sub.name')
                ->get();
          
            if ($dmcData->isEmpty()) {
                return redirect()->back()->with('error', 'No marks data found.');
            }

            

            $class = DB::table('classes')->find($dmcData[0]->class_id);
            $section = DB::table('sections')->find($dmcData[0]->section_id);
            $class_name = $class->name ?? 'N/A';
            $section_name = $section->name ?? 'N/A';

            $subjectNames = $dmcData->pluck('subject_name')->unique()->toArray();
            $subjectDetails = DB::table('subjects')
                ->whereIn('name', $subjectNames)
                ->get()
                ->keyBy('name');

            $issue_date = $request->issue_date ?? now()->format('Y-m-d');

            $pdf = Pdf::loadView('dmc.show', compact(
                'dmcData', 'schoolName', 'schoolLogo','logoBase64','exam_sign_Base64', 'schoolAddress', 'schoolContact', 'schoolEmail',
                'school_session', 'class_name', 'section_name', 'subjectDetails', 'issue_date','examControllerSign'
            ))->setPaper('A4', 'portrait')->setOptions(['defaultFont' => 'sans-serif']);

            // Save PDF
            $fileName = 'DMC_' . $studentId . '.pdf';

            // Create directory if it doesn't exist
            Storage::disk('public')->makeDirectory('dmcs');

            // Save the PDF to the storage/app/public/dmcs/ folder
            $pdf->save(storage_path('app/public/dmcs/' . $fileName));

            // Commit DB transaction
            DB::commit();

            // Return the file for download (set deleteFileAfterSend to true if needed)
            return response()->download(storage_path('app/public/dmcs/' . $fileName))->deleteFileAfterSend(false);

        }

        if ($feeMode == 'class') {
            $classId = $request->class;
            $sectionId = $request->section;
            $examId = $request->exam;
            $sessionId = $request->session;
            $issue_date = $request->issue_date ?? now()->format('Y-m-d');
          

            $students = Student::whereHas('latestAdmission', function ($q) use ($classId, $sectionId, $sessionId, $school_session) {
                $q->where('class_id', $classId)
                    ->where('section_id', $sectionId)
                    ->where('session_year', $school_session);
            })->get();
            // Dump raw SQL with bindings
 
            
            if ($students->isEmpty()) {
                return redirect()->back()->with('error', 'No students found for this class.');
            }

            Storage::disk('public')->makeDirectory('dmcs/class');
            $zip = new ZipArchive();
            $zipFilePath = storage_path('app/public/dmcs/class_dmcs.zip');

            if (file_exists($zipFilePath)) {
                unlink($zipFilePath); // remove old zip if it exists
            }

            if ($zip->open($zipFilePath, ZipArchive::CREATE | ZipArchive::OVERWRITE) === true) {
                foreach ($students as $student) {
                    $studentId = $student->id;

                    $dmcData = DB::table('student_marks as sm')
                        ->join('students as s', 'sm.student_id', '=', 's.id')
                        ->join('admissions as a', 's.id', '=', 'a.student_id')
                        ->join('subjects as sub', 'sm.subject', '=', 'sub.id')
                        ->join('exams as e', 'sm.exam', '=', 'e.id')
                        ->where('sm.student_id', $studentId)
                        ->where('sm.exam', $examId)
                        ->where('a.status', 'active')
                        ->select(
                            's.student_name', 's.father_name', 's.gender', 's.date_of_birth',
                            's.place_of_birth', 's.religion', 's.mother_name', 's.permanent_address',
                            'a.reg_no', 'a.admission_no', 'a.class_id', 'a.section_id', 'a.roll_number',
                            'e.title as exam_name', 'sub.name as subject_name', 'sm.marks'
                        )
                        ->orderBy('sub.name')
                        ->get();

                    if ($dmcData->isEmpty()) continue;

                    $schoolName = School_setting::where('setting_key', 'school_name')->value('setting_value');
                    $schoolLogo = School_setting::where('setting_key', 'school_logo')->value('setting_value');
                    $schoolLogo = $schoolLogo ? url('school-logo/' . $schoolLogo) : asset('assets/logo.png');
                    $schoolAddress = School_setting::where('setting_key', 'school_address')->value('setting_value');
                    $schoolContact = School_setting::where('setting_key', 'phone_number')->value('setting_value');
                    $schoolEmail = School_setting::where('setting_key', 'email')->value('setting_value');
                    $school_session = School_session::find($sessionId)?->session_year ?? 'N/A';

                    $class = DB::table('classes')->find($dmcData[0]->class_id);
                    $section = DB::table('sections')->find($dmcData[0]->section_id);
                    $class_name = $class->name ?? 'N/A';
                    $section_name = $section->name ?? 'N/A';

                    $subjectNames = $dmcData->pluck('subject_name')->unique()->toArray();
                    $subjectDetails = DB::table('subjects')
                        ->whereIn('name', $subjectNames)
                        ->get()
                        ->keyBy('name');

                    $pdf = Pdf::loadView('dmc.show', compact(
                        'dmcData', 'schoolName', 'schoolLogo','logoBase64','exam_sign_Base64', 'schoolAddress', 'schoolContact', 'schoolEmail',
                        'school_session', 'class_name', 'section_name', 'subjectDetails', 'issue_date'
                    ))->setPaper('A4', 'portrait')->setOptions(['defaultFont' => 'sans-serif']);

                    $fileName = 'DMC_' . $studentId . '.pdf';
                    $pdfPath = storage_path('app/public/dmcs/class/' . $fileName);
                    $pdf->save($pdfPath);

                    $zip->addFile($pdfPath, $fileName);
                }

                $zip->close();

                DB::commit();
                   return response()->download($zipFilePath)->deleteFileAfterSend(false);

            } else {
                DB::rollBack();
                return redirect()->back()->with('error', 'Could not create ZIP file.');
            }
        }
    } catch (\Exception $e) {
        DB::rollBack();
        return redirect()->back()->with('error', 'Error generating DMC: ' . $e->getMessage());
    }

    return view('dmc.generate');
}

    public function viewDmc($studentId)
    {
        // Logic to view the DMC for a specific student
        // This could involve fetching student data, marks, etc.
        return view('dmc.view', ['studentId' => $studentId]);
    }
    public function downloadDmc($studentId)
    {
        // Logic to download the DMC for a specific student
        // This could involve generating a PDF or other format
        return response()->download(storage_path("app/dmc/{$studentId}.pdf"));
    }
    public function printDmc($studentId)
    {
        // Logic to print the DMC for a specific student
        $dmc = $this->viewDmc($studentId);
        return view('dmc.print', ['dmc' => $dmc]);
    }
    public function searchDmc(Request $request)
    {
        // Logic to search for DMCs based on criteria
        $query = $request->input('query');
        // Perform search logic here, e.g., querying the database
        return view('dmc.search', ['query' => $query]);
    }
    public function bulkGenerateDmc(Request $request)
    {
        // Logic to generate DMCs for multiple students
        $studentIds = $request->input('student_ids');
        // Perform bulk generation logic here
        return redirect()->route('dmc.index')->with('success', 'DMCs generated successfully for selected students.');
    }
    public function bulkDownloadDmc(Request $request)
    {
        // Logic to download DMCs for multiple students
        $studentIds = $request->input('student_ids');
        // Perform bulk download logic here
        return response()->download(storage_path("app/dmc/bulk.zip"));
    }
    public function bulkPrintDmc(Request $request)
    {
        // Logic to print DMCs for multiple students
        $studentIds = $request->input('student_ids');
        // Perform bulk print logic here
        return view('dmc.bulk_print', ['studentIds' => $studentIds]);
    }
    public function dmcHistory($studentId)
    {
        // Logic to view the DMC history for a specific student
        // This could involve fetching previous DMCs or related data
        return view('dmc.history', ['studentId' => $studentId]);
    }

   public function getSubject(Request $request)
{
    $subjectId = $request->query('subject_id');

    if (!$subjectId) {
        return response()->json(['error' => 'Subject ID is required'], 400);
    }

    // Retrieve a single subject
    $subject = \App\Models\Subject::find($subjectId);

    if (!$subject) {
        return response()->json(['error' => 'Subject not found'], 404);
    }

    // Return only the required fields
    return response()->json([
        'total_marks' => $subject->total_marks,
        'passing_marks' => $subject->passing_marks,
    ]);
}

}
