<?php

namespace App\Http\Controllers;

use App\Models\Student;
use App\Models\Expense_categorie;
use App\Models\Income_category;
use App\Models\Job_position;
use App\Models\NewStudentApplication;
use App\Models\Student_collect_fee;
use App\Models\Student_fee;
use App\Models\Transaction_detail;
use Illuminate\Support\Facades\DB;
use Barryvdh\DomPDF\Facade\Pdf;

class DashboardController extends Controller
{
    public function index()
    {
        $stdCountClass = DB::table('admissions')
            ->join('classes', 'admissions.class_id', '=', 'classes.id')
            ->select('classes.name', DB::raw('count(admissions.id) as active_count'))
            ->where('admissions.status', 'active')
            ->groupBy('classes.name')
            ->get();



        $positions = Job_position::withCount([
            'staff_members as active_count' => function ($query) {
                $query->where('status', 'active');
            }
        ])
            ->having('active_count', '>', 0)
            ->get();



        $totalStudents = Student::whereHas('latestAdmission')
            ->where('status', 'active')
            ->count(); // Total number of active students with admission

        $totalAlumni = Student::where('status', 'completed')
            ->count();


        $classes  = DB::table('classes')->get();
        $sections = DB::table('sections')->get();

        $stdDiscountExpense = (float) Student_fee::sum('discount') + (float) Student_collect_fee::sum('discount');


        //Cash in hand head code is 20500
        $cashInHandBalance = Transaction_detail::where('coa_id', '20500')->sum('debit')
            - Transaction_detail::where('coa_id', '20500')->sum('credit');

        // head code for receivable is 20600
        $studentDue =   Transaction_detail::where('coa_id', '20600')->sum('debit')
            - Transaction_detail::where('coa_id', '20600')->sum('credit');

        // head code for Payable is 20900
        $payable =   Transaction_detail::where('coa_id', '20900')->sum('debit')
            - Transaction_detail::where('coa_id', '20900')->sum('credit');

        $expCatHeadCode = Expense_categorie::pluck('head_code');
        $expTotalDebit = Transaction_detail::whereIn('coa_id', $expCatHeadCode)->sum('debit');
        $expTotalCredit = Transaction_detail::whereIn('coa_id', $expCatHeadCode)->sum('credit');
        $totalExpense = $expTotalDebit - $expTotalCredit;

        // head code for Salary Expense is 20300
        $totalSalaryExpense =   Transaction_detail::where('coa_id', '20300')->sum('debit')
            - Transaction_detail::where('coa_id', '20300')->sum('credit');

        $incomeCatHeadCode = Income_category::pluck('head_code');
        $incomeTotalDebit = Transaction_detail::whereIn('coa_id', $incomeCatHeadCode)->sum('debit');
        $incomeTotalCredit = Transaction_detail::whereIn('coa_id', $incomeCatHeadCode)->sum('credit');
        $totalOtherIncome = $incomeTotalDebit - $incomeTotalCredit;

        $incomeFromStd = Transaction_detail::whereIn('coa_id', ['20400'])
            ->sum('debit') -
            Transaction_detail::whereIn('coa_id', ['20400'])
            ->sum('credit');

        $accept = NewStudentApplication::where('status', '2')->count();
        $pending = NewStudentApplication::where('status', '1')->count();
        $reject = NewStudentApplication::where('status', '3')->count();

        return view('dashboard', compact('accept', 'pending', 'reject', 'cashInHandBalance', 'totalExpense', 'totalSalaryExpense', 'totalOtherIncome', 'incomeFromStd', 'studentDue', 'stdDiscountExpense', 'payable', 'classes', 'sections', 'totalStudents', 'totalAlumni', 'stdCountClass', 'positions'));
    }

    public function pdfDashboard()
    {
        $stdCountClass = DB::table('admissions')
            ->join('classes', 'admissions.class_id', '=', 'classes.id')
            ->select('classes.name', DB::raw('count(admissions.id) as active_count'))
            ->where('admissions.status', 'active')
            ->groupBy('classes.name')
            ->get();

        $positions = Job_position::withCount([
            'staff_members as active_count' => function ($query) {
                $query->where('status', 'active');
            }
        ])->having('active_count', '>', 0)->get();

        $totalStudents = Student::whereHas('latestAdmission')->where('status', 'active')->count();
        $totalAlumni = Student::where('status', 'completed')->count();

        $cashInHandBalance = Transaction_detail::where('coa_id', '20500')->sum('debit')
            - Transaction_detail::where('coa_id', '20500')->sum('credit');

        $studentDue = Transaction_detail::where('coa_id', '20600')->sum('debit')
            - Transaction_detail::where('coa_id', '20600')->sum('credit');

        $payable = Transaction_detail::where('coa_id', '20900')->sum('debit')
            - Transaction_detail::where('coa_id', '20900')->sum('credit');

        $expCatHeadCode = Expense_categorie::pluck('head_code');
        $expTotalDebit = Transaction_detail::whereIn('coa_id', $expCatHeadCode)->sum('debit');
        $expTotalCredit = Transaction_detail::whereIn('coa_id', $expCatHeadCode)->sum('credit');
        $totalExpense = $expTotalDebit - $expTotalCredit;

        $totalSalaryExpense = Transaction_detail::where('coa_id', '20300')->sum('debit')
            - Transaction_detail::where('coa_id', '20300')->sum('credit');

        $incomeCatHeadCode = Income_category::pluck('head_code');
        $incomeTotalDebit = Transaction_detail::whereIn('coa_id', $incomeCatHeadCode)->sum('debit');
        $incomeTotalCredit = Transaction_detail::whereIn('coa_id', $incomeCatHeadCode)->sum('credit');
        $totalOtherIncome = $incomeTotalDebit - $incomeTotalCredit;

        $incomeFromStd = Transaction_detail::where('coa_id', '20400')->sum('debit')
            - Transaction_detail::where('coa_id', '20400')->sum('credit');

        $accept = NewStudentApplication::where('status', '2')->count();
        $pending = NewStudentApplication::where('status', '1')->count();
        $reject = NewStudentApplication::where('status', '3')->count();

        $pdf = Pdf::loadView('pdfDashboard', compact(
            'accept',
            'pending',
            'reject',
            'cashInHandBalance',
            'totalExpense',
            'totalSalaryExpense',
            'totalOtherIncome',
            'incomeFromStd',
            'studentDue',
            'payable',
            'totalStudents',
            'totalAlumni',
            'stdCountClass',
            'positions'
        ))->setPaper('A4', 'portrait');

        return $pdf->download('School-Dashboard.pdf');
    }
}
