<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Attendance;
use App\Models\Staff_member;
use App\Models\Student;
class AttendanceApiController extends Controller
{
    public function getTodayAttendance(Request $request)
    {
        $date = $request->input('date', now()->format('Y-m-d'));

        $attendances = \App\Models\Attendance::with(['student.guardian'])
        ->whereDate('date', $date)
        ->get()
        ->map(function ($attendance) {
            return [
                'student_name'     => $attendance->student->student_name ?? 'N/A',
                'guardian_name'    => $attendance->student->guardian->guardian_name ?? 'N/A',
                'guardian_contact' => $attendance->student->guardian->guardian_contact ?? 'N/A',
                'status'           => $attendance->status,
                'date'             => $attendance->date,
            ];
        });

     

        return response()->json($attendances);
    }

    public function getAllClasses()
    {
        $classes = \App\Models\Classe::all()->map(function ($class) {
            return [
                'id'   => $class->id,
                'name' => $class->name,
            ];
        });

        return response()->json($classes);
    }

    public function getStudentsByClass($class_id)
    {
        $students = \App\Models\Student::whereHas('latestAdmission', function ($query) use ($class_id) {
                $query->where('class_id', $class_id);
            })
            ->with(['latestAdmission', 'guardian'])
            ->get()
            ->map(function ($student) {
                return [
                    'id'               => $student->id,
                    'student_name'     => $student->student_name,
                    'guardian_name'    => $student->guardian->guardian_name ?? 'N/A',
                    'guardian_contact' => $student->guardian->guardian_contact ?? 'N/A',
                ];
            });

        return response()->json($students);
    }

    public function getAttendanceByStudent($student_id)
    {
        $attendances = Attendance::where('student_id', $student_id)
            ->with('student.guardian')
            ->get()
            ->map(function ($attendance) {
                return [
                    'date'             => $attendance->date,
                    'status'           => $attendance->status,
                    'student_name'     => $attendance->student->student_name ?? 'N/A',
                    'guardian_name'    => $attendance->student->guardian->guardian_name ?? 'N/A',
                    'guardian_contact' => $attendance->student->guardian->guardian_contact ?? 'N/A',
                ];
            });

        return response()->json($attendances);
    }

    public function getStaff()
    {
        $staff = Staff_member::where('status', '!=', 'resigned')
            ->get()
            ->map(function ($staffMember) {
                return [
                    'id'         => $staffMember->id,
                    'full_name'  => $staffMember->full_name ?? 'N/A',
                    'email'      => $staffMember->email ?? 'N/A',
                    'phone'      => $staffMember->primary_contact_no ?? 'N/A',
                ];
            });

        return response()->json($staff);
    }

    public function getAll()
    {
        // Fetch students
        $students = \App\Models\Student::with(['guardian'])
            ->get()
            ->map(function ($student) {
                return [
                    'type'  => 'student',
                    'name'  => $student->student_name,
                    'phone' => $student->guardian->guardian_contact ?? 'N/A',
                ];
            });

        // Fetch staff members (excluding resigned)
        $staff = \App\Models\Staff_member::where('status', '!=', 'resigned')
            ->get()
            ->map(function ($staffMember) {
                return [
                    'type'  => 'staff',
                    'name'  => $staffMember->full_name ?? 'N/A',
                    'phone' => $staffMember->primary_contact_no ?? 'N/A',
                ];
            });

        // Merge both collections
        $combined = $students->merge($staff)->values();

        return response()->json($combined);
    }




}

